<?php
/**
* Database auth plug-in for phpBB3
*
* Authentication plug-ins is largely down to Sergey Kanareykin, our thanks to him.
*
* This is for authentication via the integrated user table
*
* @package login
* @version $Id$
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* @ignore
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

/**
* Login function
*/
function login_tgc(&$username, &$password)
{
	global $db, $config;

	// do not allow empty password
	if (!$password)
	{
		return array(
			'status'	=> LOGIN_ERROR_PASSWORD,
			'error_msg'	=> 'NO_PASSWORD_SUPPLIED',
			'user_row'	=> array('user_id' => ANONYMOUS),
		);
	}

	if (!$username)
	{
		return array(
			'status'	=> LOGIN_ERROR_USERNAME,
			'error_msg'	=> 'LOGIN_ERROR_USERNAME',
			'user_row'	=> array('user_id' => ANONYMOUS),
		);
	}

	$objMySqli = new mysqli("localhost","kchat","puter571","kchat");

	if(mysqli_connect_errno()) {
		return array(
			'status'	=> LOGIN_ERROR_EXTERNAL_AUTH,
			'error_msg'	=> 'LOGIN_ERROR_EXTERNAL_AUTH',
			'user_row'	=> array('user_id' => ANONYMOUS),
		);
	}
	$sql = "SELECT 11 as ID FROM accounts WHERE username='".mysqli_real_escape_string($objMySqli,$username)."' AND password=MD5('".mysqli_real_escape_string($objMySqli,$password)."')";

	$result = $objMySqli->query($sql);

	if($result) {
		if($result->num_rows <= 0) {
			return array(
				'status'	=> LOGIN_ERROR_USERNAME,
				'error_msg'	=> 'LOGIN_ERROR_USERNAME',
				'user_row'	=> array('user_id' => ANONYMOUS),
			);
		}

		$sql = 'SELECT user_id, username, user_password, user_passchg, user_pass_convert, user_email, user_type, user_login_attempts
			FROM ' . USERS_TABLE . "
			WHERE username_clean = '" . $db->sql_escape(utf8_clean_string($username)) . "'";
		$result = $db->sql_query($sql);
		$row = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);
		
		if($row) {
			if($row['user_type'] == USER_INACTIVE || $row['user_type'] == USER_IGNORE) {
				return array(
					'status'	=> LOGIN_ERROR_ACTIVE,
					'error_msg'	=> 'ACTIVE_ERROR',
					'user_row'	=> $row,
				);
			}
			return array(
				'status'	=> LOGIN_SUCCESS,
				'error_msg'	=> false,
				'user_row'	=> $row,
			);
		}

		return array(
			'status'	=> LOGIN_SUCCESS_CREATE_PROFILE,
			'error_msg'	=> false,
			'user_row'	=> user_row_dbext($username, sha1($password)),
		);
		$show_captcha = $config['max_login_attempts'] && $row['user_login_attempts'] >= $config['max_login_attempts'];
	} else {
	}

	return array(
		'status'		=> LOGIN_ERROR_EXTERNAL_AUTH,
		'error_msg'		=> 'LOGIN_ERROR_EXTERNAL_AUTH',
		'user_row'		=> array('user_id' => ANONYMOUS),
	);
}

function user_row_dbext($username,$password) {
	global $db, $config, $user;

	$sql = 'SELECT group_id FROM '.GROUPS_TABLE." WHERE group_name='".$db->sql_escape('REGISTERED')."' AND group_type=".GROUP_SPECIAL;
	$result = $db->sql_query($sql);
	$row = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);

	if(!$row) {
		trigger_error('NO_GROUP');
	}

	return array(
		'username'	=> $username,
		'user_password'	=> phpbb_hash($password),
		'user_email'	=> '',
		'group_id'	=> (int)$row['group_id'],
		'user_type'	=> USER_NORMAL,
		'user_ip'	=> $user->ip,
	);
}

?>
